/* Copyright Airship and Contributors */

#import "UAModifyTagsAction.h"

/**
 * Adds tags. This Action is registered under the
 * names ^+t and "add_tags_action".
 *
 * Expected argument values: NSString (single tag), NSArray (single or multiple tags), or NSDictionary (tag groups).
 * An example tag group JSON payload:
 * {
 *     "channel": {
 *         "channel_tag_group": ["channel_tag_1", "channel_tag_2"],
 *         "other_channel_tag_group": ["other_channel_tag_1"]
 *     },
 *     "named_user": {
 *         "named_user_tag_group": ["named_user_tag_1", "named_user_tag_2"],
 *         "other_named_user_tag_group": ["other_named_user_tag_1"]
 *     },
 *     "device": [ "tag", "another_tag"]
 * }
 *
 *
 * Valid situations: UASituationForegroundPush, UASituationLaunchedFromPush
 * UASituationWebViewInvocation, UASituationForegroundInteractiveButton,
 * UASituationBackgroundInteractiveButton, UASituationManualInvocation, and
 * UASituationAutomation
 *
 * Default predicate: Rejects foreground pushes with visible display options
 *
 * Result value: nil
 *
 * Error: nil
 *
 * Fetch result: UAActionFetchResultNoData
 */
@interface UAAddTagsAction : UAModifyTagsAction

/**
 * Default registry name for add tags action.
 */
extern NSString * const UAAddTagsActionDefaultRegistryName;

/**
 * Default registry alias for add tags action.
 */
extern NSString * const UAAddTagsActionDefaultRegistryAlias;

/**
 * Default registry name for add tags action.
 *
 * @deprecated Deprecated – to be removed in SDK version 14.0. Please use UAAddTagsActionDefaultRegistryName.
*/
extern NSString * const kUAAddTagsActionDefaultRegistryName DEPRECATED_MSG_ATTRIBUTE("Deprecated – to be removed in SDK version 14.0. Please use UAAddTagsActionDefaultRegistryName.");

/**
 * Default registry alias for add tags action.
 *
 * @deprecated Deprecated – to be removed in SDK version 14.0. Please use UAAddTagsActionDefaultRegistryAlias.
*/
extern NSString * const kUAAddTagsActionDefaultRegistryAlias DEPRECATED_MSG_ATTRIBUTE("Deprecated – to be removed in SDK version 14.0. Please use UAAddTagsActionDefaultRegistryAlias.");


@end
